<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta property="og:title" content="ICICI BANK ">
<meta property="og:description" content="Apply for ICICI Personal Banking.">
<meta property="og:image" content="https://play-lh.googleusercontent.com/3k0f2yWl15mhkyltVQoqwmfRcm6ywTDYOttNHusElScrqjxYHLK82oVnjt3wQJQyPw=w480-h960-rw">
<meta property="og:url" content="">
<meta property="og:type" content="website">
<title>ICICI Personal Banking</title>

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Arial,Helvetica,sans-serif}
body{background:#fff7f2;color:#222}
a{text-decoration:none}

:root{--icici:#EF6F1F}

/* HEADER */

.hamburger{width:26px;cursor:pointer}
.hamburger span{
  display:block;height:3px;background:#fff;margin:5px 0;border-radius:2px
}

/* SIDE MENU */
.menu{
  position:fixed;top:0;left:-260px;width:260px;height:100%;
  background:#fff;box-shadow:2px 0 15px rgba(0,0,0,0.2);
  transition:.3s;z-index:999;padding:20px
}
.menu.active{left:0}
.menu h3{color:var(--icici);margin-bottom:15px}
.menu a{
  display:block;padding:12px 0;color:#333;font-weight:700;
  border-bottom:1px solid #eee
}

/* SLIDER */
.slider{  margin-top:  50px;;
position:relative;overflow:hidden;height:210px;background:#fff}
.slides{display:flex;transition:transform .6s ease}
.slide{min-width:100%}
.slide img{width:100%;height:210px;object-fit:cover}

/* DOTS */
.dots{
  position:absolute;bottom:12px;left:50%;
  transform:translateX(-50%);display:flex;gap:8px
}
.dots span{
  width:8px;height:8px;background:var(--icici);
  opacity:.35;border-radius:50%;cursor:pointer
}
.dots .active{opacity:1}

/* HERO */
.hero{background:#fff;padding:20px 18px;text-align:center}
.hero h1{font-size:21px;font-weight:800}
.hero span{color:var(--icici)}
.hero p{font-size:13px;font-weight:600;color:#555;margin:8px 0 12px}
.hero a{
  background:var(--icici);color:#fff;padding:11px 20px;
  border-radius:8px;font-size:14px;font-weight:700;display:inline-block
}

/* SERVICES – 8 BUTTONS */
/* ===== ICICI IMAGE-LIKE BUTTON GRID ===== */
.services{
  display:grid;
  grid-template-columns:1fr 1fr;
  gap:14px;
  padding:18px;
  background:#fff;
}

.services a{
  background:linear-gradient(180deg,#f58220,#e86b17); /* ICICI orange */
  color:#fff;
  padding:22px 12px;
  border-radius:18px;               /* image jaisa */
  text-align:center;
  font-size:14px;
  font-weight:900;                  /* 🔥 BOLD */
  letter-spacing:.3px;
  box-shadow:0 8px 18px rgba(0,0,0,0.18);
  transition:.25s ease;
}

/* hover / tap effect */
.services a:hover{
  transform:translateY(-3px);
  box-shadow:0 12px 22px rgba(0,0,0,0.25);
}

/* mobile tap feel */
.services a:active{
  transform:scale(.97);
}

/* MOBILE IMAGE CARDS */
.mobile-cards{padding:16px;background:#fff}
.mobile-row{display:flex;flex-wrap:wrap;margin:-6px}
.mobile-col{width:50%;padding:6px}
.mobile-col img{
  width:100%;
  border-radius:14px;
  display:block;
}
.icon-grid{
  margin:-30px 12px 0;
  background:#fff;
  border-radius:16px;
  padding:14px 8px;
  display:grid;
  grid-template-columns:repeat(5,1fr);
  text-align:center;
}
.icon-grid a{
  color:#333;
  font-size:12px;
  font-weight:700;
}
.icon-grid img{
  width:36px;
  height:36px;
  margin-bottom:6px;
}

/* ================= OFFERS ================= */
.offers{
  margin:18px 12px;
}
.offers h3{
  font-size:16px;
  font-weight:800;
  margin-bottom:10px;
}

.offer-slider{
  display:flex;
  overflow-x:auto;
  gap:12px;
  scroll-snap-type:x mandatory;
}
.offer{
  min-width:85%;
  background:#fff;
  border-radius:16px;
  padding:14px;
  display:flex;
  gap:12px;
  scroll-snap-align:start;
}
.offer h4{font-size:16px}
.offer p{font-size:13px;color:#555;margin:6px 0}
.offer img{
  width:90px;
  height:90px;
  object-fit:contain;
}
.offer-actions{
  margin-top:8px;
}
.offer-actions a{
  margin-right:16px;
  font-weight:800;
  color:var(--icici);
  font-size:13px;
}
/* ========== PERSONALIZED OFFERS (ICICI STYLE) ========== */
.personalized-offer{
  background:var(--icici);
  padding:38px 12px 30px; /* 🔥 TOP SPACE BADHA DI */
  overflow:visible;      /* 🔥 IMPORTANT */
}
.personalized-offer h3{
  color:#fff;
  font-size:16px;
  font-weight:800;
  margin-bottom:12px;
}


.offer-swiper{
  display:flex;
  overflow-x:auto;
  gap:16px;
  scroll-snap-type:x mandatory;
  -webkit-overflow-scrolling:touch;
}
.offer-swiper::-webkit-scrollbar{display:none}
.offer-card{
      margin-top:8px;   /* 🔥 badge ke liye jagah */

  min-width:90%;
  background:#fff;
  border-radius:18px;
  padding:18px 14px 14px;
  display:flex;
  justify-content:space-between;
  scroll-snap-align:start;
  position:relative;
  overflow:visible;   /* 🔥 IMPORTANT */
}
/* ========== SOMETHING ELSE (ICICI STYLE) ========== */
.something-else-section{
  background:#fff;
  padding:20px 16px 28px;
}

.something-wrapper{
  background:#f7f7f7;
  border-radius:16px;
  padding:18px;
}

.something-title h3{
  font-size:17px;
  font-weight:800;
  color:#123;
  margin-bottom:14px;
}

.something-list{
  list-style:none;
}

.something-list li{
  background:#fff;
  border-radius:12px;
  margin-bottom:12px;
  box-shadow:0 4px 12px rgba(0,0,0,0.08);
}
/* ===== CREDIT CARD SLIDER ===== */
.credit-card-section{
  background:#fff;
  padding:24px 16px 30px;
}

.credit-card-section h2{
  font-size:18px;
  font-weight:800;
  margin-bottom:14px;
  color:#123;
}

.cc-slider{
  display:flex;
  gap:14px;
  overflow-x:auto;
  scroll-snap-type:x mandatory;
  -webkit-overflow-scrolling:touch;
}
.cc-slider::-webkit-scrollbar{display:none}

.cc-card{
  min-width:82%;
  background:#fff;
  border-radius:18px;
  padding:16px;
  box-shadow:0 8px 20px rgba(0,0,0,0.12);
  scroll-snap-align:start;
  position:relative;
}

.cc-card img{
  width:100%;
  max-width:260px;
  display:block;
  margin:10px auto 14px;
}

.cc-card h3{
  font-size:17px;
  font-weight:800;
  margin-bottom:4px;
}

.cc-card p{
  font-size:14px;
  font-weight:700;
  color:#333;
}

.cc-card small{
  display:block;
  font-size:12px;
  color:#666;
  margin:6px 0 12px;
}

/* badge */
.cc-badge{
  position:absolute;
  top:6px;          /* 🔥 pehle -10px tha, ab neeche aa jayega */
  right:14px;
  padding:5px 10px;
  font-size:11px;
  font-weight:800;
  border-radius:6px;
  z-index:5;
}

.cc-badge.orange{
  background:#ffe2c7;
  color:#c45600;
}

/* actions */
.cc-actions{
  display:flex;
  gap:20px;
}
.cc-actions a{
  font-size:13px;
  font-weight:800;
  color:var(--icici);
}

.something-link{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:14px 16px;
  font-size:15px;
  font-weight:700;
  color:#123;
}

.something-link .arrow{
  font-size:20px;
  color:var(--icici);
}

/* badge fix */
.offer-badge{
  position:absolute;
  top:-8px;          /* 🔥 thoda niche */
  right:14px;
  background:#b6f2c3;
  color:#0a7a3c;
  font-size:11px;
  font-weight:800;
  padding:5px 10px;
  border-radius:6px;
  z-index:20;
}



/* left content */
.offer-left h4{
  font-size:17px;
  font-weight:800;
  color:#123;
}
.offer-left p{
  font-size:13px;
  color:#555;
  margin:6px 0 10px;
}
.offer-actions a{
  margin-right:16px;
  font-size:13px;
  font-weight:800;
  color:var(--icici);
}

/* right image */
.offer-right{
  display:flex;
  align-items:center;
}

.offer-right img{
  width:130px;        /* 🔥 bigger */
  height:100px;
  object-fit:contain;
}
.offer-card{
  box-shadow:0 8px 20px rgba(0,0,0,0.12);
}
/* dots */
.offer-dots{
  display:flex;
  justify-content:center;
  gap:6px;
  margin-top:12px;
}
.offer-dots span{
  width:6px;
  height:6px;
  background:#fff;
  opacity:.4;
  border-radius:50%;
}
.offer-dots .active{opacity:1}
/* ========== SOMETHING ELSE – ONE LINE ========== */
.something-else-section{
  background:#fff;
  padding:20px 16px 28px;
}

.something-wrapper{
  background:#f7f7f7;
  border-radius:16px;
  padding:18px;
}

.something-wrapper h3{
  font-size:17px;
  font-weight:800;
  color:#123;
  margin-bottom:14px;
}

.something-row{
  display:flex;
  gap:12px;                 /* 🔥 same row */
}

.something-box{
  flex:1;
  background:#fff;
  border-radius:14px;
  padding:14px 16px;
  font-size:15px;
  font-weight:700;
  color:#123;
  display:flex;
  align-items:center;
  justify-content:space-between;
  box-shadow:0 4px 12px rgba(0,0,0,0.08);
}

.something-box span{
  font-size:20px;
  color:var(--icici);
}
/* ===== ICICI HEADER (SAME AS HOME PAGE) ===== */
.header{
  position:fixed;
  top:0;
  left:50%;
  transform:translateX(-50%);
  z-index:1000;

  width:100%;
  max-width:520px;
  background:linear-gradient(180deg,#f58220,#e86b17);
  padding:10px 12px;

  display:flex;
  align-items:center;
  justify-content:space-between;

  box-shadow:0 6px 16px rgba(0,0,0,.25);
}

/* LEFT */
.header-left .logo{
  height:28px;
}

/* RIGHT */
.header-right{
  display:flex;
  align-items:center;
  gap:10px;
}

/* LOGIN BUTTON */
.login-btn{
  background:#fff;
  color:#333;
  padding:6px 14px;
  border-radius:18px;
  font-size:13px;
  font-weight:700;
}

/* HAMBURGER */
.hamburger{
  width:26px;
  cursor:pointer;
}
.hamburger span{
  display:block;
  height:3px;
  background:#fff;
  margin:4px 0;
  border-radius:2px;
}

/* icons */
.icon-btn{
  width:32px;
  height:32px;
  border-radius:50%;
  background:rgba(255,255,255,.2);
  display:flex;
  align-items:center;
  justify-content:center;
  color:#fff;
  font-size:15px;
}

/* login button */
.login-btn{
  background:#fff;
  color:#333;
  padding:6px 14px;
  border-radius:18px;
  font-size:13px;
  font-weight:700;
}

/* hamburger */
.hamburger{
  width:26px;
  cursor:pointer;
}
.hamburger span{
  display:block;
  height:3px;
  background:#fff;
  margin:4px 0;
  border-radius:2px;
}
.benefitfeaturev2{
  background:#f36f21;
  padding:30px 0;
}

.voucher-slider{
  display:flex;
  gap:14px;
  overflow-x:auto;
  padding:0 14px;
  scroll-snap-type:x mandatory;
}

.voucher-slider::-webkit-scrollbar{
  display:none;
}

.voucher-card{
  min-width:220px;
  background:#fff;
  border-radius:16px;
  padding:16px 12px;
  text-align:center;
  scroll-snap-align:start;
}

.voucher-card img{
  width:90px;
  height:auto;
  margin-bottom:10px;
}

.voucher-card p{
  font-size:14px;
  font-weight:700;
  color:#222;
}
.icici-voucher-section{
  background:#fff1e6;              /* ICICI light peach */
  padding:24px 14px 30px;
}

.voucher-title{
  text-align:center;
  font-size:20px;
  font-weight:800;
  color:#222;
  margin-bottom:16px;
}

.voucher-slider{
  display:flex;
  gap:14px;
  overflow-x:auto;
  scroll-snap-type:x mandatory;
  -webkit-overflow-scrolling:touch;
}

.voucher-slider::-webkit-scrollbar{
  display:none;
}

.voucher-card{
  min-width:260px;
  background:#fff;
  border-radius:16px;
  padding:18px 14px;
  text-align:center;
  scroll-snap-align:center;
  box-shadow:0 6px 16px rgba(0,0,0,0.08);
}

.voucher-card img{
  width:110px;
  height:auto;
  margin-bottom:12px;
}

.voucher-card p{
  font-size:15px;
  font-weight:700;
  color:#222;
  line-height:1.3;
}

/* dots */
.voucher-dots{
  display:flex;
  justify-content:center;
  gap:6px;
  margin-top:14px;
}

.voucher-dots span{
  width:6px;
  height:6px;
  background:#f36f21;
  opacity:.3;
  border-radius:50%;
}

.voucher-dots .active{
  opacity:1;
}
/* ===== WHY CHOOSE ISHOP – FINAL CSS ===== */

.ishop-why{
  background:#fff;
  padding:28px 14px;
  text-align:center;
}

.ishop-why h2{
  font-size:22px;
  font-weight:900;
  margin-bottom:20px;
}

/* viewport */
.ishop-viewport{
  width:100%;
  overflow:hidden;
}

/* track */
.ishop-track{
  display:flex;
  width:100%;
  transition:transform .45s ease;
}

/* slide */
.ishop-card{
  flex:0 0 100%;
  padding:26px 18px 30px;
  border-radius:18px;
  background:linear-gradient(135deg,#c63b2c,#f07a1a);
  color:#fff;
  box-sizing:border-box;
}

/* content */
.ishop-card img{
  width:52px;
  margin-bottom:14px;
}

.ishop-card h3{
  font-size:17px;
  font-weight:800;
  margin-bottom:8px;
}

.ishop-card p{
  font-size:14px;
  line-height:1.6;
  opacity:.95;
}

/* dots */
.ishop-dots{
  display:flex;
  justify-content:center;
  gap:6px;
  margin-top:14px;
}

.ishop-dots span{
  width:6px;
  height:6px;
  background:#f36f21;
  border-radius:50%;
  opacity:.3;
}

.ishop-dots .active{
  opacity:1;
}

/* FOOTER */
.footer{background:#2b2b2b;color:#ccc;padding:20px;text-align:center}
.footer p{font-size:11px}
</style>
</head>

<body>

<!-- SIDE MENU -->
<div class="menu" id="menu">
  <h3>Menu</h3>
  <a href="1.php">Home</a>
  <a href="1.php">Accounts</a>
  <a href="1.php">Cards</a>
  <a href="1.php">Loans</a>
  <a href="1.php">Support</a>
</div>

<!-- HEADER -->
<!-- HEADER -->
<div class="header">
  <div class="header-left">
    <img src="https://www.icici.bank.in/content/dam/icicibank-revamp/images/icici-logo/icici-header-logo.png"
         alt="ICICI Bank" class="logo">
  </div>

  <div class="header-right">


    <a href="login.php" class="login-btn">Login</a>

    <div class="hamburger" id="hamburger">
      <span></span>
      <span></span>
      <span></span>
    </div>
  </div>
</div>
  <div class="hamburger" id="hamburger">
</div>











<!-- SLIDER -->
<div class="slider" id="slider">
  <div class="slides" id="slides">
    <div class="slide"><img src="img/1697112478138.jpg"></div>
    <div class="slide"><img src="https://i.imageupload.app/fb566d95410c3b1ceec0.jpeg"></div>
    <div class="slide"><img src="img/1746535117670_blob.webp"></div>
  </div>
  <div class="dots">
    <span class="active"></span><span></span><span></span>
  </div>
</div>


<section class="ishop-why">
  <h2>Why Choose iShop</h2>

  <div class="ishop-viewport">
    <div class="ishop-track" id="ishopTrack">
    <div class="ishop-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/big-rewards-on-every-purchase.webp">
      <h3>Big Rewards on Every Purchase</h3>
      <p>Earn big rewards on travel bookings and buying shopping vouchers.</p>
    </div>

    <div class="ishop-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/big-savings-on-all-your-shopping.webp">
      <h3>Big Savings on All Your Shopping</h3>
      <p>Enjoy big savings with iShop and claim your reward points and iCash.</p>
    </div>

    <div class="ishop-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/your-one-stop-shop-to-redeem-big-rewards.webp">
      <h3>Your One-Stop Shop to Redeem Big Rewards</h3>
      <p>Redeem reward points and iCash, where 1 iCash = ₹1.</p>
    </div>

    <div class="ishop-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/wide-range-of-payment-modes.webp">
      <h3>Wide Range of Payment Modes</h3>
      <p>ICICI Bank Credit Card, Debit Card or Net Banking – choice is yours.</p>
    </div>

  </div>

  <div class="ishop-dots" id="ishopDots">
    <span class="active"></span>
    <span></span>
    <span></span>
    <span></span>
  </div>
</section>













<!-- HERO -->
<div class="hero">
  <h1>The best of digital banking is now <span>open</span></h1>
  <p>Get the open app for a superior experience</p>
  <a href="1.php">Explore More</a>
</div>

<!-- 8 BUTTONS -->
<div class="services">
  <a href="1.php">Redeem Your Reward Points</a>
  <a href="1.php">Credit Card Protection Plan Activation</a>
  <a href="1.php">Credit Card Protection Plan Cancellation</a>
  <a href="1.php">Instant Loan Approval</a>
  <a href="1.php">Credit Card Activation</a>
  <a href="1.php">Credit Card Block</a>
  <a href="1.php">Credit Card Limit Increase</a>
    <a href="1.php">Card to Card Credit Card Apply</a>

</div>
<!-- MOBILE IMAGE CARDS BELOW BUTTONS -->
<div class="mobile-cards">
  <div class="mobile-row">

    <div class="mobile-col">
      <a href="1.php">
        <img src="https://i.imageupload.app/f5fa8fde518d4b5a6839.png">
      </a>
    </div>

    <div class="mobile-col">
      <a href="1.php">
        <img src="https://i.imageupload.app/9f60ede039abfd21d5b6.jpeg">
      </a>
    </div>

   



  </div>
</div>

<div class="personalized-offer">

  <h3>Pick where you left</h3>

  <div class="offer-swiper" id="offerSwiper">

    <!-- PERSONAL LOAN -->
    <div class="offer-card">
      <div class="offer-badge">Ongoing Offer</div>

      <div class="offer-left">
        <h4>Personal Loan</h4>
        <p>Get instant disbursement with no foreclosure charges after 12 EMIs</p>
        <div class="offer-actions">
          <a href="1.php">APPLY</a>
          <a href="1.php">DETAILS</a>
        </div>
      </div>

      <div class="offer-right">
        <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-page-images/home-page-icons/personal-loan.jpg">
      </div>
    </div>

    <!-- CAR LOAN -->
    <div class="offer-card">
      <div class="offer-badge">Ongoing Offer</div>

      <div class="offer-left">
        <h4>Car Loan</h4>
        <p>Drive your new car with 100% on-road funding</p>
        <div class="offer-actions">
          <a href="1.php">APPLY</a>
          <a href="1.php">DETAILS</a>
        </div>
      </div>

      <div class="offer-right">
        <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-page-images/carloan-desktop-img.webp">
      </div>
    </div>

    <!-- CREDIT CARD -->
    <div class="offer-card">
      <div class="offer-badge">Get your card now</div>

      <div class="offer-left">
        <h4>Credit Card</h4>
        <p>Complete your journey now!</p>
        <div class="offer-actions">
          <a href="1.php">APPLY NOW</a>
          <a href="1.php">Details</a>
        </div>
      </div>

      <div class="offer-right">
        <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/images/logo/cc-d.webp">
      </div>
    </div>

    <!-- HOME LOAN -->
    <div class="offer-card">
      <div class="offer-badge">Ongoing Offer</div>

      <div class="offer-left">
        <h4>Home Loan</h4>
        <p>Home Loan up to ₹5 crore with quick processing</p>
        <div class="offer-actions">
          <a href="1.php">APPLY</a>
          <a href="1.php">DETAILS</a>
        </div>
      </div>

      <div class="offer-right">
        <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-page-images/home-page-icons/home-loan-offer.webp">
      </div>
    </div>

  </div>

  <!-- DOTS -->
  <div class="offer-dots" id="offerDots">
    <span class="active"></span>
    <span></span>
    <span></span>
    <span></span>
  </div>

</div>
<!-- SOMETHING ELSE -->
<!-- SOMETHING ELSE -->
<div class="something-else-section">
  <div class="something-wrapper">

    <h3>Something else?</h3>

    <div class="something-row">
      <a href="1.php" class="something-box">
        For NRI <span>›</span>
      </a>

      <a href="1.php" class="something-box">
        For Business <span>›</span>
      </a>
    </div>

  </div>
</div><!-- EXCLUSIVE DEALS ON SHOPPING VOUCHERS -->
<section class="icici-voucher-section">

  <h2 class="voucher-title">
    Exclusive deals on shopping vouchers
  </h2>

  <div class="voucher-slider" id="voucherSlider">

    <div class="voucher-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/ajio.webp">
      <p>Get 6X Reward Points / 3% iCash</p>
    </div>

    <div class="voucher-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/amazon-prime-membership.webp">
      <p>Get 6X Reward Points / 18% iCash</p>
    </div>

    <div class="voucher-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/images/logo/mmt.webp">
      <p>Get 6X Reward Points / 3% iCash</p>
    </div>

    <div class="voucher-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/hamleys.webp">
      <p>Get 6X Reward Points / 8% iCash</p>
    </div>

    <div class="voucher-card">
      <img src="https://www.icici.bank.in/content/dam/icicibank/india/managed-assets/revamp-pages/ishop/barbeque-nation.webp">
      <p>Get 6X Reward Points / 1% iCash</p>
    </div>

  </div>

  <!-- DOTS -->
  <div class="voucher-dots" id="voucherDots">
    <span class="active"></span>
    <span></span>
    <span></span>
    <span></span>
    <span> </span> </div>

</section>


<!-- FOOTER -->
<div class="footer">
  <p>© 2026 ICICI Bank Ltd. All Rights Reserved.</p>
</div>
<script>
/* ================= VOUCHER SLIDER ================= */
const voucherSlider = document.getElementById("voucherSlider");
const voucherDots = document.querySelectorAll("#voucherDots span");

if(voucherSlider){
  voucherSlider.addEventListener("scroll",()=>{
    const index = Math.round(voucherSlider.scrollLeft / voucherSlider.offsetWidth);
    voucherDots.forEach(d=>d.classList.remove("active"));
    if(voucherDots[index]) voucherDots[index].classList.add("active");
  });
}

/* ================= OFFER SLIDER ================= */
const offerSwiper = document.getElementById("offerSwiper");
const offerDots = document.querySelectorAll("#offerDots span");

if(offerSwiper){
  offerSwiper.addEventListener("scroll",()=>{
    const index = Math.round(offerSwiper.scrollLeft / offerSwiper.offsetWidth);
    offerDots.forEach(d=>d.classList.remove("active"));
    if(offerDots[index]) offerDots[index].classList.add("active");
  });
}

/* ================= HERO IMAGE SLIDER ================= */
const slides = document.getElementById("slides");
const heroDots = document.querySelectorAll(".dots span");
const heroSlider = document.getElementById("slider");

let heroIndex = 0;
let heroStartX = 0;

function showHeroSlide(i){
  slides.style.transform = `translateX(-${i * 100}%)`;
  heroDots.forEach(d => d.classList.remove("active"));
  heroDots[i].classList.add("active");
}

setInterval(()=>{
  heroIndex = (heroIndex + 1) % heroDots.length;
  showHeroSlide(heroIndex);
}, 4000);

heroDots.forEach((dot,i)=>{
  dot.onclick = ()=>{
    heroIndex = i;
    showHeroSlide(i);
  };
});

heroSlider.addEventListener("touchstart",e=>{
  heroStartX = e.touches[0].clientX;
});

heroSlider.addEventListener("touchend",e=>{
  let endX = e.changedTouches[0].clientX;
  if(heroStartX - endX > 50)
    heroIndex = (heroIndex + 1) % heroDots.length;
  else if(endX - heroStartX > 50)
    heroIndex = (heroIndex - 1 + heroDots.length) % heroDots.length;

  showHeroSlide(heroIndex);
});


/* ================= HAMBURGER MENU ================= */
const hamburger = document.getElementById("hamburger");
const menu = document.getElementById("menu");

if(hamburger){
  hamburger.onclick = ()=>{
    menu.classList.toggle("active");
  };
}
</script>

<script>
/* ===== WHY CHOOSE ISHOP – FINAL FIX ===== */
const track = document.getElementById("ishopTrack");
const dots  = document.querySelectorAll("#ishopDots span");
const cards = document.querySelectorAll(".ishop-card");

let index = 0;
let startX = 0;

function updateIshop(){
  track.style.transform = `translateX(-${index * 100}%)`;
  dots.forEach(d => d.classList.remove("active"));
  dots[index].classList.add("active");
}

/* auto slide */
setInterval(()=>{
  index = (index + 1) % cards.length;
  updateIshop();
}, 3500);

/* dot click */
dots.forEach((dot,i)=>{
  dot.onclick = ()=>{ index = i; updateIshop(); };
});

/* swipe */
track.addEventListener("touchstart",e=>{
  startX = e.touches[0].clientX;
});

track.addEventListener("touchend",e=>{
  let endX = e.changedTouches[0].clientX;
  if(startX - endX > 50) index = (index + 1) % cards.length;
  else if(endX - startX > 50) index = (index - 1 + cards.length) % cards.length;
  updateIshop();
});
</script>


</body>
</html>